<#ibiztemplate>
TARGET=PSAPPDELOGIC
</#ibiztemplate>
import { Util, Verify } from '@/ibiz-core/utils';
import { EntityLogicBase } from '@/ibiz-core';

<#-- 设置参数 -->
<#macro setParam logicNode>
<#if logicNode.getPSDELogicNodeParams()??>
<#list logicNode.getPSDELogicNodeParams() as logicparam>
<#if logicparam.getSrcFieldName()?? && logicparam.getDstFieldName()??>
        <#if logicparam.getSrcFieldName() != "">
        Object.assign(params, { ${logicparam.getDstFieldName()?lower_case}: params.${logicparam.getSrcFieldName()?lower_case} });
        </#if>
        <#if logicparam.getDstPSDELogicParam?? && logicparam.getDstPSDELogicParam()?? && logicparam.getDstPSDELogicParam().getParamPSAppDataEntity()??>
        <#if logicparam.getSrcFieldName()?lower_case?contains("id") >
        Object.assign(context, { ${logicparam.getDstPSDELogicParam().getParamPSAppDataEntity().getCodeName()?lower_case} : params.${logicparam.getSrcFieldName()?lower_case} });
        </#if>
        </#if>
</#if>
</#list>
</#if>
</#macro>

<#-- 调用下一节点处理逻辑 -->
<#macro executeNext logicNode>
<#if logicNode.getPSDELogicLinks()??>
<#list logicNode.getPSDELogicLinks() as logiclink>
<#if logiclink.getDstPSDELogicNode()??>
<#assign nextnode = logiclink.getDstPSDELogicNode() />
<#list item.getPSDELogicLinks() as curLink>
<#if curLink.getId() == logiclink.getId() && curLink.getPSDELogicLinkGroupCond()??>
<#assign curIndex = curLink_index/>
</#if>
</#list>
<#if curIndex??>
        if (this.compute${curIndex}Cond(params)) {
            return this.execute${nextnode.codeName}(context, params);
        }
<#else>
        return this.execute${nextnode.codeName}(context, params);
</#if>
</#if>
</#list>
<#else>
        return params;
</#if>
</#macro>

<#-- 获取判断条件 -->
<#macro getCond item><#if item.getLogicType() == 'GROUP'><#if item.isNotMode()>!(</#if><#if item.getPSDELogicLinkConds()??><#list item.getPSDELogicLinkConds() as subLogic><#if subLogic_index gt 0><#if item.getGroupOP() == 'AND'> && </#if><#if item.getGroupOP() == 'OR'> || </#if></#if><@getCond subLogic /></#list></#if><#if item.isNotMode()>)</#if><#elseif item.getLogicType() == 'SINGLE'>Verify.testCond(params.${item.getDstFieldName()?lower_case}, '${item.getCondOP()}', '${item.getValue()}')</#if></#macro>

/**
 * ${item.name}处理逻辑基类
 *
 * @export
 * @class ${item.codeName}LogicBase
 * @extends {EntityLogicBase}
 */
export class ${item.codeName}LogicBase extends EntityLogicBase {

    /**
     * 名称
     * 
     * @protected
     * @memberof ${item.codeName}LogicBase
     */
    protected name:string ="${item.codeName}";

    /**
     * 唯一标识
     * 
     * @protected
     * @memberof ${item.codeName}LogicBase
     */
    protected id:string = "${item.id}";

    /**
     * 默认参数名称
     * 
     * @protected
     * @memberof ${item.codeName}LogicBase
     */
    protected defaultParamName:string = "${item.getDefaultParamName()}";
<#if item.getPSDELogicLinks()??>
<#list item.getPSDELogicLinks() as curLink>
<#if curLink.getPSDELogicLinkGroupCond()??>

    /**
     * 计算${curLink_index}节点结果
     * 
     * @param params 传入上下文参数
     * @returns {boolean}
     * @memberof ${item.codeName}LogicBase
     */
    public compute${curLink_index}Cond(params: any): boolean {
        <#assign linkCond = curLink.getPSDELogicLinkGroupCond() />
        if (<@getCond linkCond />) {
           return true;
        }
        return false;
    }
</#if> 
</#list>
</#if>

    /**
     * 执行逻辑
     * 
     * @param context 应用上下文
     * @param params 传入参数
     * @returns {Promise<any>}
     * @memberof ${item.codeName}LogicBase
     */
    public onExecute(context: any, params: any): Promise<any> {
        return this.execute${item.getStartPSDELogicNode().codeName}(context, params);
    }

<#if item.getPSDELogicNodes()??>
    <#list item.getPSDELogicNodes() as delogicNode>

    <#-- 开始节点 -->
    <#if delogicNode.getLogicNodeType()?? && delogicNode.getLogicNodeType() == "BEGIN">
    /**
     * ${delogicNode.getName()}
     * 
     * @protected
     * @param params 传入参数
     * @returns {Promise<any>}
     * @memberof ${item.codeName}LogicBase
     */
    protected async execute${delogicNode.codeName}(context: any, params: any): Promise<any> {
        //开始节点
        <@setParam delogicNode />
        <@executeNext delogicNode />
    }
    <#-- 行为处理节点 -->
    <#elseif delogicNode.getLogicNodeType()?? && delogicNode.getLogicNodeType() == "DEACTION">
    /**
     * ${delogicNode.getName()}
     * 
     * @protected
     * @param context 应用上下文
     * @param params 传入参数
     * @returns {Promise<any>}
     * @memberof ${item.codeName}LogicBase
     */
    protected async execute${delogicNode.codeName}(context: any, params: any): Promise<any> {
        // 行为处理节点
        <@setParam delogicNode  />
        <#if delogicNode.getDstPSAppDataEntity()?? && delogicNode.getDstPSAppDEAction()??>
        <#assign targetEntity = delogicNode.getDstPSAppDataEntity() />
        <#assign deAction = delogicNode.getDstPSAppDEAction() />
        let result: any;
        // ${targetEntity.getCodeName()}服务
        const targetService: any = await this.getService('${targetEntity.getCodeName()}');
        if (Util.isFunction(targetService['${deAction.getCodeName()}'])) {
            result = await targetService['${deAction.getCodeName()}'](context, params);
        }
        if(result && result.status == 200){
            Object.assign(params, result.data);
            <@executeNext delogicNode />
        }
        </#if>
    }
    <#-- 准备参数节点 -->
    <#elseif delogicNode.getLogicNodeType()?? && delogicNode.getLogicNodeType() == "PREPAREPARAM">
    /**
     * ${delogicNode.getName()}
     * 
     * @protected
     * @param context 应用上下文
     * @param params 传入参数
     * @returns {Promise<any>}
     * @memberof ${item.codeName}LogicBase
     */
    protected async execute${delogicNode.codeName}(context: any, params: any): Promise<any> {
        // 准备参数节点
        <@setParam delogicNode />
        <@executeNext delogicNode />
    }
    <#-- 开始流程节点 -->
    <#elseif delogicNode.getLogicNodeType()?? && delogicNode.getLogicNodeType() == "STARTWF">
    /**
     * ${delogicNode.getName()}
     * 
     * @protected
     * @param context 应用上下文
     * @param params 传入参数
     * @returns {Promise<any>}
     * @memberof ${item.codeName}LogicBase
     */
    protected async execute${delogicNode.codeName}(context: any, params: any): Promise<any> {
        throw new Error('开始流程节点暂未支持');
    }
    <#-- 异常捕获节点  -->
    <#elseif delogicNode.getLogicNodeType()?? && delogicNode.getLogicNodeType() == "THROWEXCEPTION">
    /**
     * ${delogicNode.getName()}
     * 
     * @protected
     * @param context 应用上下文
     * @param params 传入参数
     * @returns {Promise<any>}
     * @memberof ${item.codeName}LogicBase
     */
    protected async execute${delogicNode.codeName}(context: any, params: any): Promise<any> {
        throw new Error('异常捕获节点暂未支持');
    }
    <#-- 前端插件  -->
    <#elseif delogicNode.getLogicNodeType()?? && delogicNode.getLogicNodeType() == "PFPLUGIN">
    /**
     * ${delogicNode.getName()}
     * 
     * @protected
     * @param context 应用上下文
     * @param params 传入参数
     * @returns {Promise<any>}
     * @memberof ${item.codeName}LogicBase
     */
    protected async execute${delogicNode.codeName}(context: any, params: any): Promise<any> {
        throw new Error('前端插件暂未支持');
    }
    <#else>
    /**
     * ${delogicNode.getName()}
     * 
     * @protected
     * @param context 应用上下文
     * @param params 传入参数
     * @returns {Promise<any>}
     * @memberof ${item.codeName}LogicBase
     */
    protected async execute${delogicNode.codeName}(context: any, params: any): Promise<any> {
        throw new Error('${delogicNode.getLogicNodeType()}暂未支持');
    }
    </#if>
    </#list>
</#if>

}